function skyT = skyTempRdam(airTemp, time)
%SKYTEMPMRDAM Estimate the sky temperature based on air temperature and cloud cover in Rotterdam
% Usage:
% skyT = skyTempRdam(airTemp, time)
%   inputs:
%       airTemp - air temperature [C]
%       time - datenum (within the years 2009-2012)
%       airTemp and time must have the same dimensions
%   output:
%       skyTemp - estimated sky temperature [C]

% David Katzin, Wageningen University
% david.katzin@wur.nl

    load('inputs\cloudCoverRotterdam2009-2012\cloudRotterdam2009_2012.mat', 'cloudRotterdam2009_2012');
    clouds = interp1(cloudRotterdam2009_2012(:,1),cloudRotterdam2009_2012(:,2),time);
    skyT = skyTempMonteith(airTemp, clouds);
end

